require( "HiddenObject/script/style.lua" );

-- gRows and gColumns are set up in mainmenu.lua

OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};	

OkStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};


MakeDialog
{
	-- Name the modal dialog
	name="LastScreen",
	Bitmap
	{
		image="Story/32/3",
		x=kCenter,
		y=kCenter,			
			
		SetStyle(OkStyle),
		Button
		{
			x=262,
			y=-50,
			font = StandardButtonFont,
			name="enterok",
			label="close",
			type = kPush,
			default=true,	-- Make this the default button
			command =
				function()
					local result = DisplayDialog { 
								"HiddenObject/script/yesno.lua", 
								body ="replayyesno",
								title = "replaytitle" 
							};
							
							PopModal("LastScreen");
							
							if (result=='yes') then								
								SwapToModal("HiddenObject/Script/mainmenu.lua");
							else
								SwapToModal("HiddenObject/Script/hiscore.lua");	
							end					
				end
		},
	},
};